DIGITAL IMAGE SPECIAL FX

COLOR CORRECTION 102 
Advanced 1-To-1 Pixel Transformations
by William Frawley

	Last  time we examined the nature of 1-to-1 pixel transforms with a look at  some of the more common of these transforms used in image enhancement  applications. This month, we'll delve a little deeper into this topic as we probe  additional specialized transforms -- transforms which can be created by you, the  user, with ImageFX's (Nova Design) flexible Custom...Color Transform operator.  Additionally, the secrets of histograms and their importance in the color correction  process shall be completely revealed. Finally, if you've been intimidated from  getting familiar with some of the more esoteric operators that ADPro and ImageFX  have to offer, we'll hopefully expand your comfort zone with them by demystifying  their functions and use. Before we begin, however, a brief review of the nature of  1-to-1 pixel transforms is in order for any of you stragglers out there.

Review of 1-To-1 Pixel Transformations
	Remember, 1-to-1 transformations are functions which take the value of an  input pixel, process it in some way and then return a new value for that pixel. The  algorithm then moves on to the next pixel in the image and repeats the same  procedure.  Graphically, the transformation function map shows the relationship  between input intensities and output intensities of a certain image. Written  mathematically, the relationship appears as y=f(x). For example, in a Null  Transform such as y=x, absolutely nothing different happens. What goes in is  exactly the same as what comes out; hence, the name Null or Neutral Transform  (Figure 1).
	Also recall that 1-to-1 transforms do not necessarily imply a linear  relationship, only that one pixel is dealt with at a time and is not dependent on the  value of other neighboring pixels as in convolutions or dithering procedures. What  happens to that pixel's value can be described graphically by any type of curve,  linear or non-linear,  existing in a two-dimensional plane. Something can be  described as being non-linear if its output is non-proportional to its input. For  instance, a Gamma Transform could be described as a function closely resembling  a non-linear, logarithmic curve. Usually, this type of pixel transformation is used  to correct the perceived brightness of a monitor because of a phosphor's  non-linear response to the intensity of the beam striking it. With the help of  ImageFX's flexible Color Transform operator, you'll see that there are countless  non-linear transforms that can be created to change an image's overall intensity  map.

Rolling Your Own Transforms With ImageFX
	With ImageFX's Custom... Color Transform filter, you are able to create your  own transformation algorithm with considerable ease. And with release 2.0 comes  the added benefit of being able to choose how you draw the transform curve -- be  it freehand sketch, line segments or splines. With this flexibility, there is nay a  transform that will elude your arsenal of color correction tools, especially with the  ability to load and save your new transforms for future use. Of course, there are a  number of useful transforms that come with ImageFX to get you started exploring.  Release 2.0 also lets you preview the results of an operation with thumbnails of  your image; quite a handy little feature, amongst many others.  With that in mind,  let's take a look at four pixel transforms we did not have a chance to cover last  time.

Still More 1-To-1 Pixel Transforms
	THRESHOLD:  Basically, this transform is a special case of the posterization  transform. The difference here is that there is only one cut-off point resulting in a  drastic reduction in output values (Figure 2). Not too useful, except perhaps in  creating monochrome clipart where you have the ability of choosing what gets  black or white. It's important to note the overlap in function of these various  operators and filters. With the proper palette, the False Color filter (see below) can  achieve exactly the same results as this transform.
	SOLARIZE:  Despite the fact that this transform is also available as a normal  filter, reproducing it here with the Color Transform filter gives us a better idea of  it's true nature. A Solarization transform increases the brightness of all the  darkest pixels below a certain value in a negative fashion, whilst maintaining all  colors above the cut-off point with a neutral curve (Figure 3). Essentially, in this  V-shaped curve, all the hues most visible are kept intact while destroying the  darker regions of the image.
	SAWTOOTH:  This arbitrary transform provides a useful highlighting of  particular image features by dividing the input range into a series of output  sweeps, a kind of banding technique. As you can see in Figure 4, each sawtooth  acts as an extreme contrast enhancement range, giving the entire image high  contrast features. Note the wrap-around effect at the boundaries between the  sawtooth ranges. Mathematically notated as f(x)=frac(x*ranges). This transform is  commonly applied in medical imaging to help distinguish certain regions for  detailed analysis.
	DOUBLEGAMMA:  This is a transform created by myself, and to me has an  aesthetically pleasing contrast effect on images. Essentially, darker pixels are  made slightly darker without getting clipped because of the gamma-shaped curve.  Similarly, lighter regions above the midway point are brightened without the  undesirable clipping that occurs with Brightness curves. The result of this  transform has an effect similar to a carefully expanded histographic equalization  filter, a tool that, as we shall now see, is indispensable for any type of color  manipulation work.

Histograms
	First, what is a histogram? A histogram is a two-dimensional graph describing  the relative number of pixels in an image at each luminance or color value. Its  analysis determines the total number of different colors, or in the case of greyscale  images, the total number of brightness levels out of a possible 256, and charts this  population distribution graphically. The horizontal axis represents the luminosity  or brightness levels in increasing intensity from left to right, and the vertical axis  shows the relative number of pixels at each intensity level. Essentially, a  histogram conveys only where most of the pixels in an image are lying, not where  the most significant area of image is.
	However, with the use of histograms, we can more effectively apply transforms  because we are able to see the overall brightness or color distribution of an image  before we act on them. In other words, histograms help identify important  relationships between the image and its luminance distribution. For example,  mountain-shaped clusters of spikes tend to indicate a large number of pixels with  nearly the same luminance value, or if there happens to be a disproportionate  number of pixels with the same color or brightness, there will sometimes be visible  only a single spike extending to the top of the graph. Unfortunately, since the  graph is vertically scaled to show the "relative" number of pixels at a given  brightness value, the remaining pixel population with varying intensity levels will  be severely outweighed in the scaling process and might not be visible on the  graph. Your best guess or temporary removal of these offending regions would be  the only recourse to effectively work with a histogram in this circumstance.
	Histograms are most effective with full-color images containing millions of  colors as these types of images produce a more detailed and thorough distribution  curve. As shown in Figure 6, the full-color image containing 37,865 distinct colors,  as revealed by ImageFX's "Count Colors" filter, produces a histogram with a finely  detailed distribution curve; whereas the reduced color versions of the image show  a correspondingly limited number of intensity spikes. Incidentally, these  histograms were produced with ImageFX's "Histogram Equalization" filter, whose  function will be more thoroughly explained in the next section. Additionally, the  ImageFX Hook called "Hist", short for Histogram obviously, produces a color  histogram illustrating the breakdown of the color components along with  maximum, minimum and average brightness levels for each respective component  such as red, green, blue and black. Figure 7 shows a series of histograms created  by the Hist hook for each of the transforms dealt with previously.

Histographic Equalization
	Now that we know what histograms are, below are general descriptions and  implementation procedures for a few of the operators/filters in ADPro and  ImageFX that either use or are procedurally similar to histogram equalization. The  operators with similar functions are listed with the software titles in parenthesis.
	INTENSITY RANGE (ADPro)/HISTOGRAM EQUALIZATION (ImageFX):  Same  function with two different names in two different programs, this operator/filter is  a two-step process. First, the passive part of the process produces a histogram of  the current image for informational purposes. At this point you can stop here if all  you need is to see the luminance distribution curve. ImageFX 2.0 also has the  option of viewing histograms for each separate color component RGB as well.  Secondly, the active part of the procedure allows you to adjust the upper and  lower range limiters to either enhance or compress your image in various ways. If  the image shows very few, if any, significant population centers (Figure 8, top), you  can enhance the overall contrast by surrounding the distinct region with the range  limiters. This will effectively spread out the highs and lows of the image across the  entire luminance bandwidth, using as many possible brightness levels as can fit in  the available bit-planes of the image. If the image was very compressed to start  with, you will see quite dramatic results with this operator (Figure 8, middle),  almost as if a dirty film were removed from the image :-) Basically, this is a much  more versatile Contrast filter, allowing you to pick the low and high cutoff values  that might get clipped. Note that you do have to do one end of the range at a time  for this filter to work properly.
	Additionally, this filter can be used to enhance only a certain significant  region of an image. Inevitably, one of the side effects of this procedure will be a   reduced number of colors because of the number of pixels that get clipped to  either extreme. For example, in Figure 9 the image in the upper-left shows a fairly  expansive distribution of its available pixel population. We also see that there are  three significant regions of the curve. Labelled (A), (B) and (C), they represent the  darker facial features, the medium-bright background, and the very bright region  of the baseball cap, respectively. In this case, we want to enhance the regions of  the face because they are too dark, so we position the upper range limiter  somewhere between region (A) and (B) and accept the requester. This will then  scale all those pixels lying in (A) to fill the entire brightness spectrum, resulting in  a much more useful image of the subject (Figure 9, lower-right). Considering the  content of the facial expression (buahaha), the background is superfluous.
	HIST EQUALIZATION (ADPro):  Although this ADPro operator's nomenclature  may be a bit confusing with the previous function, its purpose is similar but its  results are certainly distinguishable. This operator is completely automatic,  allowing no user control. Basically, it first calculates the luminance distribution  and then modifies the distribution so it is smoothly spread across the entire  luminance bandwidth. Images with a very compressed bandwidth to start (Figure  8, top) will be affected most, but with slightly different results than the other type  of histogram equalization (Figure 8, bottom).
	DYNAMIC RANGE (ADPro and ImageFX):  This operator is exactly the same in  both of the software packages mentioned. The Dynamic Range operator calculates  the highest and lowest values found in the image. You then have the option of  setting a new minimum and maximum value. If so, the image data is remapped to  fall between the new minimum and maximum value(s), thereby either  compressing, expanding or shifting the image's luminosity distribution. The  advantage of knowing the exact minimum and maximum values contained in the  image is far outweighed by the fact that you know nothing at all about the  significance of the pixel distribution characteristics lying in-between these two  extremes. It is probably more helpful to use the Histogram Equalization (Intensity  Range in ADPro) operator for more important tasks, and simply use the Dynamic  Range operator if you need to reduce some upper level to an exact value (i.e.. to  prevent NTSC color bleeding).
	 Color Shifting/Compression/Expansion Transforms
	For the sake of completeness, let me briefly mention a couple of  operators/filters that fit the description of 1-to-1 pixel transformations and are  most useful in their own right. These particular filters are more geared toward  altering the implicit color scheme of an image, rather than explicitly manipulating  the contrast via luminance compression/expansion.
	COLOR TO GRAY (ADPro and ImageFX):  Both ADPro and ImageFX implement  this function in the same fashion. Not merely allowing conversion from color to  greyscale, this operator is capable of adjusting the weights with which the red,  green and blue color components are factored in the conversion process. This may  seem a bit esoteric, but consider this example.
	In the top image of Figure 10, you see a full-color, hand-painted nebula to be  mapped onto a plane as a color map texture in Lightwave 3D. Left at that, there  would have simply been an opaque nebula in space -- not very realistic. However,  by taking the negative greyscale of this same image, you can also apply it as a  transparency map to provide controlled regions of transparency instead of setting  the entire nebula to one lackluster value. By weighting the blue component of the  nebula considerably greater than the other components in the Color To Gray  operation, I was able to boost the contrast between the bulk of the nebula and the  black background (Figure 10, bottom). This made the unpainted areas of the  image completely transparent, but gave some opacity to the thin, wispy blue  regions of the nebula in the final transparency map. With the standard weighting  scheme, the conversion would have yielded a greyscale with much of the blue  portions indistinguishable from the black background. Then, in the final rendering  of the nebula using this transparency map, nearly all of the blue areas would have  been completely invisible.
	COLORIZE (ADPro)/FALSE COLOR (ImageFX):  This operator, like Gray To  Color, ultimately reformats a greyscale image into a color one. However, unlike its  brethren, it provides many options for actually coloring the greyscale image. I  might point out that ImageFX's False Color filter is a limited version of ADPro's  Colorize operator, functioning identical to the latter's "Currently Loaded" Colorize  option. Needless to say, ADPro's operator is much more feature-laden, and I  suggest consulting the manual for a more thorough explanation of the various  options.
	Turning to the common function of the two, specifically ImageFX's False Color  filter and ADPro's Colorize/Currently Loaded option, its whole purpose is to  (re)map an image, based upon the luminance values of each pixel, with colors from  an external color palette. See Figure 11 for an example of remapping an image  with two different color palettes using ImageFX's False Color filter. Incidentally,  this function is the same as DCTV's Remap tool [see Amazing Computing, Vol. 8,  No. 7, "Exploring Remap" for other uses]. Undoubtedly, one can spend days just  playing with this colorization filter and never fully appreciate its worth.

C-Ya-Bye
	Now that you hopefully have a better grasp of color correction and  manipulation, you can start practicing by processing your entire library of clipart  background images and textures. Once this bug bites you, I guarantee free time  will no longer appear in your vocabulary. More importantly however, let creativity  guide you on some artistic journeys of your own. Despairingly, we haven't even  begun scratching the surface of color correction, especially when you consider the  complicated process of color separation in the world of print media. Speaking of  such, if you've found this topic particularly interesting, I recommend checking out  Dan Margulis' column Make ready in PennWell Publishing's "Computer Artist"  publication. Really heavy Photoshop stuff, but nonetheless chock full of interesting  and useful color correction info. Until next time, happy IPing!
